"use strict";(self.webpackChunkwaveterm_docs=self.webpackChunkwaveterm_docs||[]).push([[42],{1122:(e,s,n)=>{n.r(s),n.d(s,{assets:()=>h,contentTitle:()=>o,default:()=>j,frontMatter:()=>r,metadata:()=>l,toc:()=>d});const l=JSON.parse('{"id":"wsh-reference","title":"wsh reference","description":"The wsh command is always available from Wave blocks. It is a powerful tool for interacting with Wave blocks and can bridge data between your CLI and the widget GUIs.","source":"@site/docs/wsh-reference.mdx","sourceDirName":".","slug":"/wsh-reference","permalink":"/docsite/wsh-reference","draft":false,"unlisted":false,"tags":[],"version":"current","sidebarPosition":4.1,"frontMatter":{"sidebar_position":4.1,"id":"wsh-reference","title":"wsh reference"},"sidebar":"defaultSidebar","previous":{"title":"wsh overview","permalink":"/docsite/wsh"},"next":{"title":"Custom Widgets","permalink":"/docsite/customwidgets"}}');var i=n(4848),a=n(3023),c=n(7982),t=n(1341);const r={sidebar_position:4.1,id:"wsh-reference",title:"wsh reference"},o="wsh command",h={},d=[{value:"view",id:"view",level:2},{value:"edit",id:"edit",level:2},{value:"getmeta",id:"getmeta",level:2},{value:"setmeta",id:"setmeta",level:2},{value:"ai",id:"ai",level:2},{value:"editconfig",id:"editconfig",level:2},{value:"setbg",id:"setbg",level:2},{value:"run",id:"run",level:2},{value:"deleteblock",id:"deleteblock",level:2},{value:"ssh",id:"ssh",level:2},{value:"wsl",id:"wsl",level:2},{value:"web",id:"web",level:2},{value:"notify",id:"notify",level:2},{value:"conn",id:"conn",level:2},{value:"status",id:"status",level:3},{value:"reinstall",id:"reinstall",level:3},{value:"disconnect",id:"disconnect",level:3},{value:"connect",id:"connect",level:3},{value:"ensure",id:"ensure",level:3},{value:"setconfig",id:"setconfig",level:2},{value:"file",id:"file",level:2},{value:"cat",id:"cat",level:3},{value:"write",id:"write",level:3},{value:"append",id:"append",level:3},{value:"rm",id:"rm",level:3},{value:"info",id:"info",level:3},{value:"cp",id:"cp",level:3},{value:"mv",id:"mv",level:3},{value:"ls",id:"ls",level:3},{value:"launch",id:"launch",level:2},{value:"getvar/setvar",id:"getvarsetvar",level:2},{value:"setvar",id:"setvar",level:3},{value:"getvar",id:"getvar",level:3},{value:"wavepath",id:"wavepath",level:2},{value:"blocks",id:"blocks",level:2},{value:"list",id:"list",level:3}];function m(e){const s={a:"a",admonition:"admonition",code:"code",em:"em",h1:"h1",h2:"h2",h3:"h3",header:"header",hr:"hr",li:"li",p:"p",pre:"pre",span:"span",strong:"strong",ul:"ul",...(0,a.R)(),...e.components};return(0,i.jsxs)(t.V9,{children:[(0,i.jsx)(s.header,{children:(0,i.jsx)(s.h1,{id:"wsh-command",children:"wsh command"})}),(0,i.jsxs)(s.p,{children:["The ",(0,i.jsx)(s.code,{children:"wsh"})," command is always available from Wave blocks. It is a powerful tool for interacting with Wave blocks and can bridge data between your CLI and the widget GUIs."]}),(0,i.jsxs)(s.p,{children:["This is the detailed wsh reference documention. For an overview of ",(0,i.jsx)(s.code,{children:"wsh"})," functionality, please see our ",(0,i.jsx)(s.a,{href:"/wsh",children:"wsh command docs"}),"."]}),(0,i.jsx)(s.hr,{}),(0,i.jsx)(s.h2,{id:"view",children:"view"}),(0,i.jsx)(s.p,{children:"You can open a preview block with the contents of any file or directory by running:"}),(0,i.jsx)(s.pre,{children:(0,i.jsx)(s.code,{className:"hljs language-sh",children:"wsh view [path]\n"})}),(0,i.jsx)(s.p,{children:"You can use this command to easily preview images, markdown files, and directories. For code/text files this will open\na codeedit block which you can use to quickly edit the file using Wave's embedded graphical editor."}),(0,i.jsx)(s.hr,{}),(0,i.jsx)(s.h2,{id:"edit",children:"edit"}),(0,i.jsx)(s.pre,{children:(0,i.jsx)(s.code,{className:"hljs language-sh",children:"wsh edit [path]\n"})}),(0,i.jsxs)(s.p,{children:["This will open up codeedit for the specified file. This is useful for quickly editing files on a local or remote machine in our graphical editor. This command will wait until the file is closed before exiting (unlike ",(0,i.jsx)(s.code,{children:"view"}),") so you can set your ",(0,i.jsx)(s.code,{children:"$EDITOR"})," to ",(0,i.jsx)(s.code,{children:"wsh editor"})," for a seamless experience. You can combine this with a ",(0,i.jsx)(s.code,{children:"-m"})," flag to open the editor in magnified mode."]}),(0,i.jsx)(s.hr,{}),(0,i.jsx)(s.h2,{id:"getmeta",children:"getmeta"}),(0,i.jsx)(s.p,{children:"You can view the metadata of any block or tab by running:"}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:[(0,i.jsx)(s.span,{className:"hljs-comment",children:"# get the metadata for the current terminal block"}),"\nwsh getmeta\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# get the metadata for block num 2 (see block numbers by holidng down Ctrl+Shift)"}),"\nwsh getmeta -b 2\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:'# get the metadata for a blockid (get block ids by right clicking any block header "Copy Block Id")'}),"\nwsh getmeta -b [blockid]\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# get the metadata for a tab"}),"\nwsh getmeta -b tab\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# dump a single metadata key"}),"\nwsh getmeta [-b [blockid]] [key]\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# dump a set of keys with a certain prefix"}),"\nwsh getmeta -b tab ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"bg:*"'}),"\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# dump a set of keys with prefix (and include the 'clear' key)"}),"\nwsh getmeta -b tab --clear-prefix ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"bg:*"'}),"\n"]})}),(0,i.jsx)(s.p,{children:"This is especially useful for preview and web blocks as you can see the file or url that they are pointing to and use that in your CLI scripts."}),(0,i.jsx)(s.p,{children:"blockid format:"}),(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"this"})," -- the current block (this is also the default)"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"tab"})," -- the id of the current tab"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"d6ff4966-231a-4074-b78a-20acc7226b41"})," -- a full blockid is a UUID"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"a67f55a3"})," -- blockids may be truncated to the first 8 characters"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"5"})," -- if a number less than 100 is given, it is a block number. blocks are numbered sequentially in the current tab from the top-left to bottom-right. holding ",(0,i.jsx)(c.u,{k:"Ctrl:Shift"})," will show a block number overlay."]}),"\n"]}),(0,i.jsx)(s.hr,{}),(0,i.jsx)(s.h2,{id:"setmeta",children:"setmeta"}),(0,i.jsxs)(s.p,{children:["You can update any metadata key value pair for blocks (and tabs) by using the setmeta command. The setmeta command takes the same ",(0,i.jsx)(s.code,{children:"-b"})," arguments as getmeta."]}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:["wsh setmeta -b [blockid] [key]=[value]\nwsh setmeta -b [blockid] file=~/myfile.txt\nwsh setmeta -b [blockid] url=https://waveterm.dev/\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# set the metadata for the current tab using the given json file"}),"\nwsh setmeta -b tab --json [jsonfile]\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# set the metadata for the current tab using a json file read from stdin"}),"\nwsh setmeta -b tab --json\n"]})}),(0,i.jsxs)(s.p,{children:['You can get block and tab ids by right clicking on the appropriate block and selecting "Copy BlockId" (or use the block number via Ctrl',":Shift","). When you\nupdate the metadata for a preview or web block you'll see the changes reflected instantly in the block."]}),(0,i.jsx)(s.p,{children:"Other useful metadata values to override block titles, icons, colors, themes, etc."}),(0,i.jsx)(s.p,{children:"Here's a complex command that will copy the background (bg:* keys) from one tab to the current tab:"}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:["wsh getmeta -b [other-tab-id] ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"bg:*"'})," --clear-prefix | wsh setmeta -b tab --json -\n"]})}),(0,i.jsx)(s.hr,{}),(0,i.jsx)(s.h2,{id:"ai",children:"ai"}),(0,i.jsx)(s.p,{children:"Append content to the Wave AI sidebar. Files are attached as proper file attachments (supporting images, PDFs, and text), not encoded as text. By default, content is added to the sidebar without auto-submitting, allowing you to review and add more context before sending to the AI."}),(0,i.jsxs)(s.p,{children:["You can attach multiple files at once (up to 15 files). Use ",(0,i.jsx)(s.code,{children:"-m"})," to add a message along with files, ",(0,i.jsx)(s.code,{children:"-s"})," to auto-submit immediately, and ",(0,i.jsx)(s.code,{children:"-n"}),' to start a new chat conversation. Use "-" to read from stdin.']}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:[(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Pipe command output to AI (ask question in UI)"}),"\ngit diff | wsh ai -\ndocker logs mycontainer | wsh ai -\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Attach files without auto-submit (review in UI first)"}),"\nwsh ai main.go utils.go\nwsh ai screenshot.png logs.txt\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Attach files with message"}),"\nwsh ai app.py -m ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"find potential bugs"'}),"\nwsh ai *.",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"log"})," -m ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"analyze these error logs"'}),"\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Auto-submit immediately"}),"\nwsh ai config.json -s -m ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"explain this configuration"'}),"\n",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"tail"})," -n 50 app.log | wsh ai -s - -m ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"what\'s causing these errors?"'}),"\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Start new chat and attach files"}),"\nwsh ai -n report.pdf data.csv -m ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"summarize these reports"'}),"\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Attach different file types (images, PDFs, code)"}),"\nwsh ai architecture.png api-spec.pdf server.go -m ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"review the system design"'}),"\n"]})}),(0,i.jsx)(s.p,{children:(0,i.jsx)(s.strong,{children:"File Size Limits:"})}),(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsx)(s.li,{children:"Text files: 200KB maximum"}),"\n",(0,i.jsx)(s.li,{children:"PDF files: 5MB maximum"}),"\n",(0,i.jsx)(s.li,{children:"Image files: 7MB maximum (accounts for base64 encoding overhead)"}),"\n",(0,i.jsx)(s.li,{children:"Maximum 15 files per command"}),"\n"]}),(0,i.jsx)(s.p,{children:(0,i.jsx)(s.strong,{children:"Flags:"})}),(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-m, --message <text>"})," - Add message text along with files"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-s, --submit"})," - Auto-submit immediately (default waits for user)"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-n, --new"})," - Clear current chat and start fresh conversation"]}),"\n"]}),(0,i.jsx)(s.hr,{}),(0,i.jsx)(s.h2,{id:"editconfig",children:"editconfig"}),(0,i.jsx)(s.p,{children:"You can easily open up any of Wave's config files using this command."}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:["wsh editconfig [config-file-name]\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# opens the default settings.json file"}),"\nwsh editconfig\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# opens presets.json"}),"\nwsh editconfig presets.json\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# opens widgets.json"}),"\nwsh editconfig widgets.json\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# opens ai presets"}),"\nwsh editconfig presets/ai.json\n"]})}),(0,i.jsx)(s.hr,{}),(0,i.jsx)(s.h2,{id:"setbg",children:"setbg"}),(0,i.jsxs)(s.p,{children:["The ",(0,i.jsx)(s.code,{children:"setbg"})," command allows you to set a background image or color for the current tab with various customization options."]}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:["wsh setbg [--opacity value] [--tile|--center] [--size value] (image-path|",(0,i.jsx)(s.span,{className:"hljs-string",children:'"#color"'}),"|color-name)\n"]})}),(0,i.jsx)(s.p,{children:"You can set a background using:"}),(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsx)(s.li,{children:"An image file (displayed as cover, tiled, or centered)"}),"\n",(0,i.jsx)(s.li,{children:'A hex color (must be quoted like "#ff0000")'}),"\n",(0,i.jsx)(s.li,{children:'A CSS color name (like "blue" or "forestgreen")'}),"\n"]}),(0,i.jsx)(s.p,{children:"Flags:"}),(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"--opacity value"})," - set the background opacity (0.0-1.0, default 0.5)"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"--tile"})," - tile the background image instead of using cover mode"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"--center"})," - center the image without scaling (good for logos)"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"--size"})," - size for centered images (px, %, or auto)"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"--clear"})," - remove the background"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"--print"})," - show the metadata without applying it"]}),"\n"]}),(0,i.jsx)(s.p,{children:"Supported image formats: JPEG, PNG, GIF, WebP, and SVG."}),(0,i.jsx)(s.p,{children:"Examples:"}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:[(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Set an image background with default settings"}),"\nwsh setbg ~/pictures/background.jpg\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Set a background with custom opacity"}),"\nwsh setbg --opacity 0.3 ~/pictures/light-pattern.png\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Set a tiled background"}),"\nwsh setbg --tile --opacity 0.2 ~/pictures/texture.png\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Center an image (good for logos)"}),"\nwsh setbg --center ~/pictures/logo.png\nwsh setbg --center --size 200px ~/pictures/logo.png\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Set color backgrounds"}),"\nwsh setbg ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"#ff0000"'}),"          ",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# hex color (requires quotes)"}),"\nwsh setbg forestgreen        ",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# CSS color name"}),"\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Change just the opacity of current background"}),"\nwsh setbg --opacity 0.7\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Remove background"}),"\nwsh setbg --clear\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Preview the metadata"}),"\nwsh setbg --",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"print"})," ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"#ff0000"'}),"\n"]})}),(0,i.jsx)(s.p,{children:"The command validates that:"}),(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsx)(s.li,{children:"Color values are valid hex codes or CSS color names"}),"\n",(0,i.jsx)(s.li,{children:"Image paths point to accessible, supported image files"}),"\n",(0,i.jsx)(s.li,{children:"The opacity value is between 0.0 and 1.0"}),"\n",(0,i.jsx)(s.li,{children:"The center and tile options are not used together"}),"\n"]}),(0,i.jsx)(s.admonition,{type:"tip",children:(0,i.jsxs)(s.p,{children:["Use ",(0,i.jsx)(s.code,{children:"--print"})," to preview the metadata for any background configuration without applying it. You can then copy this JSON representation to use as a ",(0,i.jsx)(s.a,{href:"/presets#background-configurations",children:"Background Preset"})]})}),(0,i.jsx)(s.hr,{}),(0,i.jsx)(s.h2,{id:"run",children:"run"}),(0,i.jsxs)(s.p,{children:["The ",(0,i.jsx)(s.code,{children:"run"})," command creates a new terminal command block and executes a specified command within it. The command can be provided either as arguments after ",(0,i.jsx)(s.code,{children:"--"})," or using the ",(0,i.jsx)(s.code,{children:"-c"})," flag. Unless the ",(0,i.jsx)(s.code,{children:"-x"})," or ",(0,i.jsx)(s.code,{children:"-X"})," flags are passed, commands can be re-executed by pressing ",(0,i.jsx)(s.code,{children:"Enter"})," once the command has finished running."]}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:[(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Run a command specified after --"}),"\nwsh run -- ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"ls"})," -la\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Run a command using -c flag"}),"\nwsh run -c ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"ls -la"'}),"\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Run with working directory specified"}),"\nwsh run --cwd /path/to/dir -- ./script.sh\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Run in magnified mode"}),"\nwsh run -m -- make build\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Run and auto-close on successful completion"}),"\nwsh run -x -- npm ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"test"}),"\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Run and auto-close regardless of exit status"}),"\nwsh run -X -- ./long-running-task.sh\n"]})}),(0,i.jsx)(s.p,{children:"The command inherits the current environment variables and working directory by default."}),(0,i.jsx)(s.p,{children:"Flags:"}),(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-m, --magnified"})," - open the block in magnified mode"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-c, --command string"})," - run a command string in ",(0,i.jsx)(s.em,{children:"shell"})]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-x, --exit"})," - close block if command exits successfully (stays open if there was an error)"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-X, --forceexit"})," - close block when command exits, regardless of exit status"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"--delay int"})," - if using -x/-X, delay in milliseconds before closing block (default 2000)"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-p, --paused"})," - create block in paused state"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-a, --append"})," - append output on command restart instead of clearing"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"--cwd string"})," - set working directory for command"]}),"\n"]}),(0,i.jsx)(s.p,{children:"Examples:"}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:[(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Run a build command in magnified mode"}),"\nwsh run -m -- npm run build\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Execute a script and auto-close after success"}),"\nwsh run -x -- ./backup-script.sh\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Run a command in a specific directory"}),"\nwsh run --cwd ./project -- make ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"test"}),"\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Run a shell command and force close after completion"}),"\nwsh run -X -c ",(0,i.jsx)(s.span,{className:"hljs-string",children:"\"find . -name '*.log' -delete\""}),"\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Start a command in paused state"}),"\nwsh run -p -- ./server --dev\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Run with custom close delay"}),"\nwsh run -x --delay 5000 -- ./deployment.sh\n"]})}),(0,i.jsxs)(s.p,{children:["When using the ",(0,i.jsx)(s.code,{children:"-x"})," or ",(0,i.jsx)(s.code,{children:"-X"})," flags, the block will automatically close after the command completes. The ",(0,i.jsx)(s.code,{children:"-x"})," flag only closes on successful completion (exit code 0), while ",(0,i.jsx)(s.code,{children:"-X"})," closes regardless of exit status. The ",(0,i.jsx)(s.code,{children:"--delay"})," flag controls how long to wait before closing (default 2000ms)."]}),(0,i.jsxs)(s.p,{children:["The ",(0,i.jsx)(s.code,{children:"-p"})," flag creates the block in a paused state, allowing you to review the command before execution."]}),(0,i.jsx)(s.admonition,{type:"tip",children:(0,i.jsxs)(s.p,{children:["You can use either ",(0,i.jsx)(s.code,{children:"--"})," followed by your command and arguments, or the ",(0,i.jsx)(s.code,{children:"-c"})," flag with a quoted command string. The ",(0,i.jsx)(s.code,{children:"--"})," method is preferred when you want to preserve argument handling, while ",(0,i.jsx)(s.code,{children:"-c"})," is useful for shell commands with pipes or redirections."]})}),(0,i.jsx)(s.hr,{}),(0,i.jsx)(s.h2,{id:"deleteblock",children:"deleteblock"}),(0,i.jsx)(s.pre,{children:(0,i.jsx)(s.code,{className:"hljs language-sh",children:"wsh deleteblock -b [blockid]\n"})}),(0,i.jsx)(s.p,{children:"This will delete the block with the specified id."}),(0,i.jsx)(s.hr,{}),(0,i.jsx)(s.h2,{id:"ssh",children:"ssh"}),(0,i.jsx)(s.pre,{children:(0,i.jsx)(s.code,{className:"hljs language-sh",children:"wsh ssh [user@host]\n"})}),(0,i.jsxs)(s.p,{children:["This will use Wave's internal ssh implementation to connect to the specified remote machine. The ",(0,i.jsx)(s.code,{children:"-i"})," flag can be used to specify a path to an identity file."]}),(0,i.jsx)(s.hr,{}),(0,i.jsx)(s.h2,{id:"wsl",children:"wsl"}),(0,i.jsx)(s.pre,{children:(0,i.jsx)(s.code,{className:"hljs language-sh",children:"wsh wsl [-d <distribution-name>]\n"})}),(0,i.jsx)(s.p,{children:"This will connect to a WSL distribution on the local machine. It will use the default if no distribution is provided."}),(0,i.jsx)(s.hr,{}),(0,i.jsx)(s.h2,{id:"web",children:"web"}),(0,i.jsx)(s.p,{children:"You can search for a given url using:"}),(0,i.jsx)(s.pre,{children:(0,i.jsx)(s.code,{className:"hljs language-sh",children:"wsh web open [url]\n"})}),(0,i.jsx)(s.p,{children:"Alternatively, you can search with the configured search engine using:"}),(0,i.jsx)(s.pre,{children:(0,i.jsx)(s.code,{className:"hljs language-sh",children:"wsh web open [search-query]\n"})}),(0,i.jsx)(s.p,{children:"Both of these commands will open a new web block with the desired page."}),(0,i.jsx)(s.hr,{}),(0,i.jsx)(s.h2,{id:"notify",children:"notify"}),(0,i.jsxs)(s.p,{children:["The ",(0,i.jsx)(s.code,{children:"notify"})," command creates a desktop notification from Wave Terminal."]}),(0,i.jsx)(s.pre,{children:(0,i.jsx)(s.code,{className:"hljs language-sh",children:"wsh notify [message] [-t title] [-s]\n"})}),(0,i.jsx)(s.p,{children:"This allows you to trigger desktop notifications from scripts or commands. The notification will appear using your system's native notification system. It works on remote machines as well as your local machine."}),(0,i.jsx)(s.p,{children:"Flags:"}),(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-t, --title string"}),' - set the notification title (default "Wsh Notify")']}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-s, --silent"})," - disable the notification sound"]}),"\n"]}),(0,i.jsx)(s.p,{children:"Examples:"}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:[(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Basic notification"}),"\nwsh notify ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"Build completed successfully"'}),"\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Notification with custom title"}),"\nwsh notify -t ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"Deployment Status"'})," ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"Production deployment finished"'}),"\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Silent notification"}),"\nwsh notify -s ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"Background task completed"'}),"\n"]})}),(0,i.jsx)(s.p,{children:"This is particularly useful for long-running commands where you want to be notified of completion or status changes."}),(0,i.jsx)(s.hr,{}),(0,i.jsx)(s.h2,{id:"conn",children:"conn"}),(0,i.jsx)(s.p,{children:"This has several subcommands which all perform various features related to connections."}),(0,i.jsx)(s.h3,{id:"status",children:"status"}),(0,i.jsx)(s.pre,{children:(0,i.jsx)(s.code,{className:"hljs language-sh",children:"wsh conn status\n"})}),(0,i.jsx)(s.p,{children:"This command gives the status of all connections made since waveterm started."}),(0,i.jsx)(s.h3,{id:"reinstall",children:"reinstall"}),(0,i.jsx)(s.p,{children:"For ssh connections,"}),(0,i.jsx)(s.pre,{children:(0,i.jsx)(s.code,{className:"hljs language-sh",children:"wsh conn reinstall [user@host]\n"})}),(0,i.jsx)(s.p,{children:"For wsl connections,"}),(0,i.jsx)(s.pre,{children:(0,i.jsx)(s.code,{className:"hljs language-sh",children:"wsh conn reinstall [wsl://<distribution-name>]\n"})}),(0,i.jsx)(s.p,{children:"This command reinstalls the Wave Shell Extensions on the specified connection."}),(0,i.jsx)(s.h3,{id:"disconnect",children:"disconnect"}),(0,i.jsx)(s.p,{children:"For ssh connections,"}),(0,i.jsx)(s.pre,{children:(0,i.jsx)(s.code,{className:"hljs language-sh",children:"wsh conn disconnect [user@host]\n"})}),(0,i.jsx)(s.p,{children:"For wsl connections,"}),(0,i.jsx)(s.pre,{children:(0,i.jsx)(s.code,{className:"hljs language-sh",children:"wsh conn disconnect [wsl://<distribution name>]\n"})}),(0,i.jsx)(s.p,{children:"This command completely disconnects the specified connection. This will apply to all blocks where the connection is being used"}),(0,i.jsx)(s.h3,{id:"connect",children:"connect"}),(0,i.jsx)(s.p,{children:"For ssh connections,"}),(0,i.jsx)(s.pre,{children:(0,i.jsx)(s.code,{className:"hljs language-sh",children:"wsh conn connect [user@host]\n"})}),(0,i.jsx)(s.p,{children:"For wsl connections,"}),(0,i.jsx)(s.pre,{children:(0,i.jsx)(s.code,{className:"hljs language-sh",children:"wsh conn connect [wsl://<distribution-name>]\n"})}),(0,i.jsx)(s.p,{children:"This command connects to the specified connection but does not create a block for it."}),(0,i.jsx)(s.h3,{id:"ensure",children:"ensure"}),(0,i.jsx)(s.p,{children:"For ssh connections,"}),(0,i.jsx)(s.pre,{children:(0,i.jsx)(s.code,{className:"hljs language-sh",children:"wsh conn ensure [user@host]\n"})}),(0,i.jsx)(s.p,{children:"For wsl connections,"}),(0,i.jsx)(s.pre,{children:(0,i.jsx)(s.code,{className:"hljs language-sh",children:"wsh conn ensure [wsl://<distribution-name>]\n"})}),(0,i.jsx)(s.p,{children:"This command connects to the specified connection if it isn't already connected."}),(0,i.jsx)(s.hr,{}),(0,i.jsx)(s.h2,{id:"setconfig",children:"setconfig"}),(0,i.jsx)(s.pre,{children:(0,i.jsx)(s.code,{className:"hljs language-sh",children:"wsh setconfig [<config-name>=<config-value>]\n"})}),(0,i.jsxs)(s.p,{children:["This allows setting various options in the ",(0,i.jsx)(s.code,{children:"config/settings.json"})," file. It will check to be sure a valid config option was provided."]}),(0,i.jsx)(s.hr,{}),(0,i.jsx)(s.h2,{id:"file",children:"file"}),(0,i.jsxs)(s.p,{children:["The ",(0,i.jsx)(s.code,{children:"file"})," command provides a set of subcommands for managing files across different storage systems, such as ",(0,i.jsx)(s.code,{children:"wavefile"}),", ",(0,i.jsx)(s.code,{children:"wsh"})," remote servers, and S3."]}),(0,i.jsxs)(s.admonition,{type:"note",children:[(0,i.jsx)(s.p,{children:"Wave Terminal is capable of managing files from remote SSH hosts, S3-compatible\nsystems, and the internal Wave filesystem. Files are addressed via URIs, which\nvary depending on the storage system. If no scheme is specified, the file will be treated as a local connection."}),(0,i.jsxs)(s.p,{children:["URI format: ",(0,i.jsx)(s.code,{children:"[profile]:[uri-scheme]://[connection]/[path]"})]}),(0,i.jsx)(s.p,{children:"Supported URI schemes:"}),(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsxs)(s.li,{children:["\n",(0,i.jsxs)(s.p,{children:[(0,i.jsx)(s.code,{children:"wsh"})," - Used to access files on remote hosts over SSH via the WSH helper. Allows for file streaming to Wave and other remotes."]}),"\n",(0,i.jsx)(s.p,{children:'Profiles are optional for WSH URIs, provided that you have configured the remote host in your "connections.json" or "~/.ssh/config" file.'}),"\n",(0,i.jsx)(s.p,{children:'If a profile is provided, it must be defined in "profiles.json" in the Wave configuration directory.'}),"\n",(0,i.jsxs)(s.p,{children:["Format: ",(0,i.jsx)(s.code,{children:"wsh://[remote]/[path]"})]}),"\n",(0,i.jsxs)(s.p,{children:["Shorthands can be used for the current remote and your local computer:\n",(0,i.jsx)(s.code,{children:"[path]"})," a relative or absolute path on the current remote\n",(0,i.jsx)(s.code,{children:"//[remote]/[path]"})," a path on a remote\n",(0,i.jsx)(s.code,{children:"/~/[path]"})," a path relative to the home directory on your local computer"]}),"\n"]}),"\n",(0,i.jsxs)(s.li,{children:["\n",(0,i.jsxs)(s.p,{children:[(0,i.jsx)(s.code,{children:"s3"}),' - Used to access files on S3-compatible systems.\nRequires S3 credentials to be set up, either in the AWS CLI configuration files, or in "profiles.json" in the Wave configuration directory.']}),"\n",(0,i.jsx)(s.p,{children:'If no profile is provided, the default from your AWS CLI configuration will be used. Profiles from the AWS CLI must be prefixed with "aws:".'}),"\n",(0,i.jsx)(s.p,{children:"Format:"}),"\n",(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsx)(s.li,{children:(0,i.jsx)(s.code,{children:"s3://[bucket]/[path]"})}),"\n",(0,i.jsx)(s.li,{children:(0,i.jsx)(s.code,{children:"aws:[profile]:s3://[bucket]/[path]"})}),"\n",(0,i.jsx)(s.li,{children:(0,i.jsx)(s.code,{children:"[profile]:s3://[bucket]/[path]"})}),"\n"]}),"\n"]}),"\n",(0,i.jsxs)(s.li,{children:["\n",(0,i.jsxs)(s.p,{children:[(0,i.jsx)(s.code,{children:"wavefile"})," - Used to retrieve blockfiles from the internal Wave filesystem."]}),"\n",(0,i.jsxs)(s.p,{children:["Format: ",(0,i.jsx)(s.code,{children:"wavefile://[zoneid]/[path]"})]}),"\n",(0,i.jsx)(s.p,{children:"Wave file locations can be:"}),"\n",(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"wavefile://block/..."}),' - stored in the current block ("this" is also an alias for "block")']}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"wavefile://tab/..."})," - stored in the current tab"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"wavefile://workspace/..."}),' - stored in the current workspace ("ws" is also an alias for "workspace")']}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"wavefile://client/..."}),' - stored globally for the client ("global" is also an alias for "client")']}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"wavefile://temp/..."})," - stored globally, but removed on startup/shutdown"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"wavefile://[uuid]/..."})," - an entity id (can be a block, tab, workspace, etc.)"]}),"\n"]}),"\n"]}),"\n"]})]}),(0,i.jsx)(s.h3,{id:"cat",children:"cat"}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:["wsh file ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"cat"})," [file-uri]\n"]})}),(0,i.jsx)(s.p,{children:"Display the contents of a file. For example:"}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:["wsh file ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"cat"})," wavefile://block/config.txt\nwsh file ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"cat"})," wavefile://client/settings.json\n"]})}),(0,i.jsx)(s.h3,{id:"write",children:"write"}),(0,i.jsx)(s.pre,{children:(0,i.jsx)(s.code,{className:"hljs language-sh",children:"wsh file write [file-uri]\n"})}),(0,i.jsx)(s.p,{children:"Write data from stdin to a file. The maximum file size is 10MB. For example:"}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:[(0,i.jsx)(s.span,{className:"hljs-built_in",children:"echo"})," ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"hello"'})," | wsh file write wavefile://block/greeting.txt\n",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"cat"})," config.json | wsh file write //ec2-user@remote01/~/config.json\n"]})}),(0,i.jsx)(s.h3,{id:"append",children:"append"}),(0,i.jsx)(s.pre,{children:(0,i.jsx)(s.code,{className:"hljs language-sh",children:"wsh file append [file-uri]\n"})}),(0,i.jsx)(s.p,{children:"Append data from stdin to a file, respecting a 10MB total file size limit. This is useful for log files or accumulating data. For example:"}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:[(0,i.jsx)(s.span,{className:"hljs-built_in",children:"tail"})," -f app.log | wsh file append wavefile://block/logs.txt\n",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"echo"})," ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"new line"'})," | wsh file append wavefile://client/notes.txt\n"]})}),(0,i.jsx)(s.h3,{id:"rm",children:"rm"}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:["wsh file ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"rm"})," [flag] [file-uri]\n"]})}),(0,i.jsx)(s.p,{children:"Remove a file. For example:"}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:["wsh file ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"rm"})," wsh://user@ec2/home/user/config.txt\nwsh file ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"rm"})," wavefile://client/settings.json\n"]})}),(0,i.jsx)(s.p,{children:"Flags:"}),(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-r, --recursive"})," - recursively deletes directory entries"]}),"\n"]}),(0,i.jsx)(s.h3,{id:"info",children:"info"}),(0,i.jsx)(s.pre,{children:(0,i.jsx)(s.code,{className:"hljs language-sh",children:"wsh file info [file-uri]\n"})}),(0,i.jsx)(s.p,{children:"Display information about a file including size, creation time, modification time, and metadata. For example:"}),(0,i.jsx)(s.pre,{children:(0,i.jsx)(s.code,{className:"hljs language-sh",children:"wsh file info wsh://user@ec2/home/user/config.txt\nwsh file info wavefile://client/settings.json\n"})}),(0,i.jsx)(s.h3,{id:"cp",children:"cp"}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:["wsh file ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"cp"})," [flags] [source-uri] [destination-uri]\n"]})}),(0,i.jsx)(s.p,{children:"Copy files between different storage systems. For example:"}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:[(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Copy a wave file into your local filesystem"}),"\nwsh file ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"cp"})," wavefile://block/config.txt ./local-config.txt\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Copy a local file into the wave filesystem"}),"\nwsh file ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"cp"})," ./local-config.txt wavefile://block/config.txt\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Copy a remote file into the wave filesystem"}),"\nwsh file ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"cp"})," wsh://user@ec2/home/user/config.txt wavefile://client/config.txt\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Recursively copy a directory between two remote computers"}),"\nwsh file ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"cp"})," wsh://user@ec2-1/home/user/.config wsh://user@ec2-2/home/user/.config -r\n"]})}),(0,i.jsx)(s.p,{children:"Flags:"}),(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-r, --recursive"})," - copies all files in a directory recursively"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-f, --force"})," - overwrites any conflicts when copying"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-m, --merge"})," - does not clear existing directory entries when copying a directory, instead merging its contents with the destination's"]}),"\n"]}),(0,i.jsx)(s.h3,{id:"mv",children:"mv"}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:["wsh file ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"mv"})," [flags] [source-uri] [destination-uri]\n"]})}),(0,i.jsx)(s.p,{children:"Move files between different storage systems. The source file will be deleted once the operation completes successfully. For example:"}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:[(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Move a wave file into your local filesystem"}),"\nwsh file ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"mv"})," wavefile://block/config.txt ./local-config.txt\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Move a local file into the wave filesystem"}),"\nwsh file ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"mv"})," ./local-config.txt wavefile://block/config.txt\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Move a remote file into the wave filesystem"}),"\nwsh file ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"mv"})," wsh://user@ec2/home/user/config.txt wavefile://client/config.txt\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Recursively move a directory between two remote computers"}),"\nwsh file ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"mv"})," wsh://user@ec2-1/home/user/.config wsh://user@ec2-2/home/user/.config -r\n"]})}),(0,i.jsx)(s.p,{children:"Flags:"}),(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-r, --recursive"})," - moves all files in a directory recursively"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-f, --force"})," - overwrites any conflicts when moving"]}),"\n"]}),(0,i.jsx)(s.h3,{id:"ls",children:"ls"}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:["wsh file ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"ls"})," [flags] [file-uri]\n"]})}),(0,i.jsx)(s.p,{children:"List files in a directory. By default, lists files in the current directory for the current terminal session."}),(0,i.jsx)(s.p,{children:"Examples:"}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:["wsh file ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"ls"})," wsh://user@ec2/home/user/\nwsh file ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"ls"})," wavefile://client/configs/\n"]})}),(0,i.jsx)(s.p,{children:"Flags:"}),(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-l, --long"})," - use long listing format showing size, timestamps, and metadata"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-r, --recursive"})," - list subdirectories recursively"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-1, --one"})," - list one file per line"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-f, --files"})," - list only files (no directories)"]}),"\n"]}),(0,i.jsx)(s.p,{children:"When output is piped to another command, automatically switches to one-file-per-line format:"}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:[(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Easy to process with grep, awk, etc."}),"\nwsh file ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"ls"})," wavefile://client/ | grep ",(0,i.jsx)(s.span,{className:"hljs-string",children:'".json$"'}),"\n"]})}),(0,i.jsx)(s.hr,{}),(0,i.jsx)(s.h2,{id:"launch",children:"launch"}),(0,i.jsxs)(s.p,{children:["The ",(0,i.jsx)(s.code,{children:"wsh launch"})," command allows you to open pre-configured widgets directly from your terminal."]}),(0,i.jsx)(s.pre,{children:(0,i.jsx)(s.code,{className:"hljs language-sh",children:"wsh launch [flags] widget-id\n"})}),(0,i.jsx)(s.p,{children:"The command will search for the specified widget ID in both user-defined widgets and default widgets, then create a new block using the widget's configuration."}),(0,i.jsx)(s.p,{children:"Flags:"}),(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-m, --magnify"})," - open the widget in magnified mode, overriding the widget's default magnification setting"]}),"\n"]}),(0,i.jsx)(s.p,{children:"Examples:"}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:[(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Launch a widget with its default settings"}),"\nwsh launch my-custom-widget\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Launch a widget in magnified mode"}),"\nwsh launch -m system-monitor\n"]})}),(0,i.jsxs)(s.p,{children:["The widget's configuration determines the initial block settings, including the view type, metadata, and default magnification state. The ",(0,i.jsx)(s.code,{children:"-m"})," flag can be used to override the widget's default magnification setting."]}),(0,i.jsx)(s.admonition,{type:"tip",children:(0,i.jsxs)(s.p,{children:["Widget configurations can be customized in your ",(0,i.jsx)(s.code,{children:"widgets.json"})," configuration file, which you can edit using ",(0,i.jsx)(s.code,{children:"wsh editconfig widgets.json"})]})}),(0,i.jsx)(s.hr,{}),(0,i.jsx)(s.h2,{id:"getvarsetvar",children:"getvar/setvar"}),(0,i.jsx)(s.p,{children:"Wave Terminal provides commands for managing persistent variables at different scopes (block, tab, workspace, or client-wide)."}),(0,i.jsx)(s.h3,{id:"setvar",children:"setvar"}),(0,i.jsx)(s.pre,{children:(0,i.jsx)(s.code,{className:"hljs language-sh",children:"wsh setvar [flags] KEY=VALUE...\n"})}),(0,i.jsxs)(s.p,{children:["Set one or more variables. By default, variables are set at the client (global) level. Use ",(0,i.jsx)(s.code,{children:"-l"})," for block-local variables."]}),(0,i.jsx)(s.p,{children:"Examples:"}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:[(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Set a single variable"}),"\nwsh setvar API_KEY=abc123\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Set multiple variables at once"}),"\nwsh setvar HOST=localhost PORT=8080 DEBUG=",(0,i.jsx)(s.span,{className:"hljs-literal",children:"true"}),"\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Set a block-local variable"}),"\nwsh setvar -l BLOCK_SPECIFIC=value\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Remove variables"}),"\nwsh setvar -r API_KEY PORT\n"]})}),(0,i.jsx)(s.p,{children:"Flags:"}),(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-l, --local"})," - set variables local to the current block"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-r, --remove"})," - remove the specified variables instead of setting them"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"--varfile string"}),' - use a different variable file (default "var")']}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-b [blockid]"})," - used to set a specific zone (block, tab, workspace, client, or UUID)"]}),"\n"]}),(0,i.jsx)(s.h3,{id:"getvar",children:"getvar"}),(0,i.jsx)(s.pre,{children:(0,i.jsx)(s.code,{className:"hljs language-sh",children:"wsh getvar [flags] [key]\n"})}),(0,i.jsx)(s.p,{children:"Get the value of a variable. Returns exit code 0 if the variable exists, 1 if it doesn't. This allows for shell scripting like:"}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:[(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Check if a variable exists"}),"\n",(0,i.jsx)(s.span,{className:"hljs-keyword",children:"if"})," wsh getvar API_KEY >/dev/null; ",(0,i.jsx)(s.span,{className:"hljs-keyword",children:"then"}),"\n    ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"echo"})," ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"API key is set"'}),"\n",(0,i.jsx)(s.span,{className:"hljs-keyword",children:"fi"}),"\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Use a variable in a command"}),"\ncurl -H ",(0,i.jsxs)(s.span,{className:"hljs-string",children:['"Authorization: ',(0,i.jsx)(s.span,{className:"hljs-subst",children:"$(wsh getvar API_KEY)"}),'"']})," https://api.example.com\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Get a block-local variable"}),"\nwsh getvar -l BLOCK_SPECIFIC\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# List all variables"}),"\nwsh getvar --all\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# List all variables with null terminators (for scripting)"}),"\nwsh getvar --all -0\n"]})}),(0,i.jsx)(s.p,{children:"Flags:"}),(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-l, --local"})," - get variables local to the current block"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"--all"})," - list all variables"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-0, --null"})," - use null terminators in output instead of newlines"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"--varfile string"}),' - use a different variable file (default "var")']}),"\n"]}),(0,i.jsxs)(s.p,{children:["Variables can be accessed at different scopes using the ",(0,i.jsx)(s.code,{children:"-b"})," flag:"]}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:[(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Get/set at block level"}),"\nwsh getvar -b block MYVAR\nwsh setvar -b block MYVAR=value\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Get/set at tab level"}),"\nwsh getvar -b tab MYVAR\nwsh setvar -b tab MYVAR=value\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Get/set at workspace level"}),"\nwsh getvar -b workspace MYVAR\nwsh setvar -b workspace MYVAR=value\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Get/set at client (global) level"}),"\nwsh getvar -b client MYVAR\nwsh setvar -b client MYVAR=value\n"]})}),(0,i.jsx)(s.p,{children:"Variables set with these commands persist across sessions and can be used to store configuration values, secrets, or any other string data that needs to be accessible across blocks or tabs."}),(0,i.jsx)(s.h2,{id:"wavepath",children:"wavepath"}),(0,i.jsxs)(s.p,{children:["The ",(0,i.jsx)(s.code,{children:"wavepath"})," command lets you get the paths to various Wave Terminal directories and files, including configuration, data storage, and logs."]}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:["wsh wavepath {config|data|",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"log"}),"}\n"]})}),(0,i.jsx)(s.p,{children:"This command returns the full path to the requested Wave Terminal system directory or file. It's useful for accessing Wave's configuration files, data storage, or checking logs."}),(0,i.jsx)(s.p,{children:"Flags:"}),(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-o, --open"})," - open the path in a new block"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-O, --open-external"})," - open the path in the default external application"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-t, --tail"})," - show the last ~100 lines of the log file (only valid for log path)"]}),"\n"]}),(0,i.jsx)(s.p,{children:"Examples:"}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:[(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Get path to config directory"}),"\nwsh wavepath config\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Get path to data directory"}),"\nwsh wavepath data\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Get path to log file"}),"\nwsh wavepath ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"log"}),"\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Open log file in a new block"}),"\nwsh wavepath -o ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"log"}),"\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Open config directory in system file explorer"}),"\nwsh wavepath -O config\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# View recent log entries"}),"\nwsh wavepath -t ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"log"}),"\n"]})}),(0,i.jsx)(s.p,{children:"The command will show you the full path to:"}),(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"config"})," - Where Wave Terminal stores its configuration files"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"data"})," - Where Wave Terminal stores its persistent data"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"log"})," - The main Wave Terminal log file"]}),"\n"]}),(0,i.jsx)(s.admonition,{type:"tip",children:(0,i.jsxs)(s.p,{children:["Use the ",(0,i.jsx)(s.code,{children:"-t"})," flag with the log path to quickly view recent log entries without having to open the full file. This is particularly useful for troubleshooting."]})}),(0,i.jsx)(s.hr,{}),(0,i.jsx)(s.h2,{id:"blocks",children:"blocks"}),(0,i.jsxs)(s.p,{children:["The ",(0,i.jsx)(s.code,{children:"blocks"})," command provides operations for listing and querying blocks across workspaces, windows, and tabs. Primarily useful for debugging and scripting."]}),(0,i.jsx)(s.h3,{id:"list",children:"list"}),(0,i.jsx)(s.pre,{children:(0,i.jsx)(s.code,{className:"hljs language-sh",children:"wsh blocks list [flags]\n"})}),(0,i.jsx)(s.p,{children:"List all blocks with optional filtering by workspace, window, tab, or view type. Output can be formatted as a table (default) or JSON for scripting."}),(0,i.jsx)(s.p,{children:"Flags:"}),(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"--workspace <id>"})," - restrict to specific workspace id"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"--window <id>"})," - restrict to specific window id"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"--tab <id>"})," - restrict to specific tab id"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"--view <type>"})," - filter by view type (term, web, preview, edit, sysinfo, waveai)"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"--json"})," - output results as JSON"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"--timeout <ms>"})," - RPC timeout in milliseconds (default: 5000)"]}),"\n"]}),(0,i.jsx)(s.p,{children:"Examples:"}),(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-sh",children:[(0,i.jsx)(s.span,{className:"hljs-comment",children:"# List all blocks"}),"\nwsh blocks list\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# List only terminal blocks"}),"\nwsh blocks list --view=term\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Filter by workspace"}),"\nwsh blocks list --workspace=12d0c067-378e-454c-872e-77a314248114\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Output as JSON for scripting"}),"\nwsh blocks list --json\n"]})})]})}function j(e={}){const{wrapper:s}={...(0,a.R)(),...e.components};return s?(0,i.jsx)(s,{...e,children:(0,i.jsx)(m,{...e})}):m(e)}},1341:(e,s,n)=>{n.d(s,{FX:()=>m,V9:()=>o,ZC:()=>x,rP:()=>t});var l=n(7773),i=n(6540),a=n(1750),c=n(4848);const t=(0,i.createContext)(void 0);const r=({children:e})=>{const[s,n]=(0,i.useState)(function(){var e=window.navigator.platform;return-1!==["Macintosh","MacIntel","MacPPC","Mac68K"].indexOf(e)||-1!==["iPhone","iPad","iPod"].indexOf(e)?"mac":-1!==["Win32","Win64","Windows","WinCE"].indexOf(e)?"windows":"linux"}()),l=(0,i.useCallback)(e=>{n(e),localStorage.setItem("platform",e)},[]);return(0,c.jsx)(t.Provider,{value:{platform:s,setPlatform:l},children:e})},o=({children:e})=>(0,c.jsx)(l.A,{fallback:(0,c.jsx)("div",{}),children:()=>(0,c.jsx)(r,{children:e})}),h=()=>{const e=(0,i.useContext)(t);if(!e)throw new Error("usePlatform must be used within a PlatformProvider");return e},d=()=>{const{platform:e,setPlatform:s}=h();return(0,c.jsxs)("div",{className:"pill-toggle",children:[(0,c.jsx)("button",{className:(0,a.A)("pill-option",{active:"mac"===e}),onClick:()=>s("mac"),children:"macOS"}),(0,c.jsx)("button",{className:(0,a.A)("pill-option",{active:"linux"===e}),onClick:()=>s("linux"),children:"Linux"}),(0,c.jsx)("button",{className:(0,a.A)("pill-option",{active:"windows"===e}),onClick:()=>s("windows"),children:"Windows"})]})},m=()=>(0,c.jsx)(l.A,{fallback:(0,c.jsx)("div",{}),children:()=>(0,c.jsx)(d,{})}),j=({children:e,platforms:s})=>{const n=h();return s.includes(n.platform)&&e},x=e=>(0,c.jsx)(l.A,{fallback:(0,c.jsx)("div",{}),children:()=>(0,c.jsx)(j,{...e})})},3023:(e,s,n)=>{n.d(s,{R:()=>c,x:()=>t});var l=n(6540);const i={},a=l.createContext(i);function c(e){const s=l.useContext(a);return l.useMemo(function(){return"function"==typeof e?e(s):{...s,...e}},[s,e])}function t(e){let s;return s=e.disableParentContext?"function"==typeof e.components?e.components(i):e.components||i:c(e.components),l.createElement(a.Provider,{value:s},e.children)}},7773:(e,s,n)=>{n.d(s,{A:()=>a});n(6540);var l=n(462),i=n(4848);function a({children:e,fallback:s}){return(0,l.A)()?(0,i.jsx)(i.Fragment,{children:e?.()}):s??null}},7982:(e,s,n)=>{n.d(s,{Y:()=>o,u:()=>r});var l=n(7773),i=n(6540),a=n(1341),c=n(4848);const t=({k:e})=>{const{platform:s}=(0,i.useContext)(a.rP),n=e.split(":").map((e,n)=>{const[l,i,a]=function(e,s){return"Arrows"==s?[(0,c.jsx)("span",{className:"spaced",children:"\u2191\u2192\u2193\u2190"}),"Arrow Keys",!0]:"ArrowUp"==s?["\u2191","Arrow Up",!0]:"ArrowRight"==s?["\u2192","Arrow Right",!0]:"ArrowDown"==s?["\u2193","Arrow Down",!0]:"ArrowLeft"==s?["\u2190","Arrow Left",!0]:"Cmd"==s?"mac"===e?["\u2318","Command",!0]:["Alt","Alt",!1]:"Ctrl"==s?"mac"===e?["\u2303","Control",!0]:["Ctrl","Control",!1]:"Shift"==s?["\u21e7","Shift",!0]:"Escape"==s?["Esc","Escape",!1]:[s.length>1?s:s.toUpperCase(),s,!1]}(s,e);return(0,c.jsx)("kbd",{title:i,"aria-label":i,className:a?"symbol":null,children:l},n)});return(0,c.jsx)("div",{className:"kbd-group",children:n})},r=({k:e})=>(0,c.jsx)(l.A,{fallback:(0,c.jsx)("kbd",{children:e}),children:()=>(0,c.jsx)(t,{k:e})}),o=({karr:e})=>{const s=[];for(let l=0;l<e.length;l++)l>0&&s.push((0,c.jsx)("span",{style:{padding:"0 2px"},children:"+"})),s.push((0,c.jsx)(r,{k:e[l]},l));const n=(0,c.jsx)("span",{style:{whiteSpace:"nowrap"},children:s});return(0,c.jsx)(l.A,{fallback:null,children:()=>n})}}}]);