"use strict";(self.webpackChunkwaveterm_docs=self.webpackChunkwaveterm_docs||[]).push([[388],{3023:(e,s,n)=>{n.d(s,{R:()=>t,x:()=>c});var l=n(6540);const i={},a=l.createContext(i);function t(e){const s=l.useContext(a);return l.useMemo(function(){return"function"==typeof e?e(s):{...s,...e}},[s,e])}function c(e){let s;return s=e.disableParentContext?"function"==typeof e.components?e.components(i):e.components||i:t(e.components),l.createElement(a.Provider,{value:s},e.children)}},3834:(e,s,n)=>{n.r(s),n.d(s,{assets:()=>r,contentTitle:()=>c,default:()=>d,frontMatter:()=>t,metadata:()=>l,toc:()=>o});const l=JSON.parse('{"id":"wsh","title":"wsh overview","description":"The wsh command provides Wave Terminal\'s core command line interface, allowing users to interact with both terminal and graphical elements from the command line. This guide covers the basics of using wsh and its key features.","source":"@site/docs/wsh.mdx","sourceDirName":".","slug":"/wsh","permalink":"/docsite/wsh","draft":false,"unlisted":false,"tags":[],"version":"current","sidebarPosition":4,"frontMatter":{"sidebar_position":4,"id":"wsh","title":"wsh overview"},"sidebar":"defaultSidebar","previous":{"title":"AI Presets","permalink":"/docsite/ai-presets"},"next":{"title":"wsh reference","permalink":"/docsite/wsh-reference"}}');var i=n(4848),a=n(3023);const t={sidebar_position:4,id:"wsh",title:"wsh overview"},c=void 0,r={},o=[{value:"Overview",id:"overview",level:2},{value:"Key Concepts",id:"key-concepts",level:2},{value:"Interacting with Blocks",id:"interacting-with-blocks",level:3},{value:"Persistent State",id:"persistent-state",level:3},{value:"Block Management",id:"block-management",level:3},{value:"Common Workflows",id:"common-workflows",level:2},{value:"Development Workflow",id:"development-workflow",level:3},{value:"Remote Development",id:"remote-development",level:3},{value:"AI-Assisted Development",id:"ai-assisted-development",level:3},{value:"Tips &amp; Features",id:"tips--features",level:2},{value:"Scripting with wsh",id:"scripting-with-wsh",level:2},{value:"Getting Help",id:"getting-help",level:2}];function h(e){const s={a:"a",code:"code",h2:"h2",h3:"h3",li:"li",ol:"ol",p:"p",pre:"pre",span:"span",strong:"strong",ul:"ul",...(0,a.R)(),...e.components};return(0,i.jsxs)(i.Fragment,{children:[(0,i.jsxs)(s.p,{children:["The ",(0,i.jsx)(s.code,{children:"wsh"})," command provides Wave Terminal's core command line interface, allowing users to interact with both terminal and graphical elements from the command line. This guide covers the basics of using ",(0,i.jsx)(s.code,{children:"wsh"})," and its key features."]}),"\n",(0,i.jsxs)(s.p,{children:["See the ",(0,i.jsx)(s.a,{href:"/wsh-reference",children:"wsh reference"})," for a list of all wsh commands and their arguments."]}),"\n",(0,i.jsx)(s.h2,{id:"overview",children:"Overview"}),"\n",(0,i.jsxs)(s.p,{children:["At its core, ",(0,i.jsx)(s.code,{children:"wsh"})," enables seamless interaction between your terminal commands and Wave's graphical blocks. It allows you to:"]}),"\n",(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsx)(s.li,{children:"Control graphical widgets directly from the command line"}),"\n",(0,i.jsx)(s.li,{children:"Share data between terminal sessions and GUI components"}),"\n",(0,i.jsx)(s.li,{children:"Manage your workspace programmatically"}),"\n",(0,i.jsx)(s.li,{children:"Connect remote and local environments"}),"\n",(0,i.jsx)(s.li,{children:"Send CLI output and files directly to AI conversations"}),"\n",(0,i.jsx)(s.li,{children:"Run terminal commands in separate, isolated blocks"}),"\n"]}),"\n",(0,i.jsx)(s.h2,{id:"key-concepts",children:"Key Concepts"}),"\n",(0,i.jsx)(s.h3,{id:"interacting-with-blocks",children:"Interacting with Blocks"}),"\n",(0,i.jsxs)(s.p,{children:[(0,i.jsx)(s.code,{children:"wsh"})," provides direct interaction with Wave's graphical blocks through the command line. For example:"]}),"\n",(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-bash",children:[(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Open a file in the editor"}),"\nwsh edit config.json\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Get the current file path from a preview block"}),"\nwsh getmeta -b 2 file\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:'# Send output to an AI assistant (the "-" reads from stdin)'}),"\n",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"ls"})," -la | wsh ai - ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"what are the largest files here?"'}),"\n"]})}),"\n",(0,i.jsx)(s.h3,{id:"persistent-state",children:"Persistent State"}),"\n",(0,i.jsxs)(s.p,{children:[(0,i.jsx)(s.code,{children:"wsh"})," can maintain state across terminal sessions through its variable and file storage system:"]}),"\n",(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-bash",children:[(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Store a variable that persists across sessions"}),"\nwsh setvar API_KEY=abc123\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Store globally"}),"\nwsh setvar DEPLOY_ENV=prod\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Or store in the current workspace"}),"\nwsh setvar -b workspace DEPLOY_ENV=staging\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Use stored variables in commands"}),"\ncurl -H ",(0,i.jsxs)(s.span,{className:"hljs-string",children:['"Authorization: ',(0,i.jsx)(s.span,{className:"hljs-subst",children:"$(wsh getvar API_KEY)"}),'"']})," https://api.example.com\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Store a file that can be accessed from any block"}),"\n",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"echo"})," ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"data"'})," | wsh file write wavefile://global/config.txt\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Append logs from multiple terminals"}),"\n",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"echo"})," ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"Terminal 1 log"'})," | wsh file append wavefile://workspace/logs.txt\n"]})}),"\n",(0,i.jsx)(s.h3,{id:"block-management",children:"Block Management"}),"\n",(0,i.jsxs)(s.p,{children:["Every visual element in Wave is a block, and ",(0,i.jsx)(s.code,{children:"wsh"})," gives you complete control over them (hold Ctrl+Shift to see block numbers):"]}),"\n",(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-bash",children:[(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Create a new block showing a webpage"}),"\nwsh web open github.com\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Do a web search in a new block"}),"\nwsh web open ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"wave terminal"'}),"\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Run a command in a new block and auto-close when done"}),"\nwsh run -x -- npm ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"test"}),"\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Get information about the current block"}),"\nwsh getmeta\n"]})}),"\n",(0,i.jsx)(s.h2,{id:"common-workflows",children:"Common Workflows"}),"\n",(0,i.jsxs)(s.p,{children:["Here are some common ways to use ",(0,i.jsx)(s.code,{children:"wsh"}),":"]}),"\n",(0,i.jsx)(s.h3,{id:"development-workflow",children:"Development Workflow"}),"\n",(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-bash",children:[(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Open directory or markdown files"}),"\nwsh view .\nwsh view README.md\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:'# add a -m to open the block in "magnified" mode'}),"\nwsh view -m README.md\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Start development server in a new block (-m will magnify the block on startup)"}),"\nwsh run -m -- npm run dev\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Open documentation in a web block"}),"\nwsh web open http://localhost:3000\n"]})}),"\n",(0,i.jsx)(s.h3,{id:"remote-development",children:"Remote Development"}),"\n",(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-bash",children:[(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Connect to remote server with optional key"}),"\nwsh ssh -i ~/.ssh/mykey.pem dev@server\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Edit remote files"}),"\nwsh edit /etc/nginx/nginx.conf\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Monitor remote logs"}),"\nwsh run -- ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"tail"})," -f /var/log/app.log\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Share variables between sessions"}),"\nwsh setvar -b tab SHARED_ENV=staging\n"]})}),"\n",(0,i.jsx)(s.h3,{id:"ai-assisted-development",children:"AI-Assisted Development"}),"\n",(0,i.jsxs)(s.p,{children:["The ",(0,i.jsx)(s.code,{children:"wsh ai"})," command appends content to the Wave AI sidebar. By default, files are attached without auto-submitting, allowing you to review and add more context before sending."]}),"\n",(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-bash",children:[(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Pipe output to AI sidebar (ask question in UI)"}),"\ngit diff | wsh ai -\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Attach files with a message"}),"\nwsh ai main.go utils.go -m ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"find bugs in these files"'}),"\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Auto-submit with message"}),"\nwsh ai config.json -s -m ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"explain this config"'}),"\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Start new chat with attached files"}),"\nwsh ai -n *.",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"log"})," -m ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"analyze these logs"'}),"\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Attach multiple file types (images, PDFs, code)"}),"\nwsh ai screenshot.png report.pdf app.py -m ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"review these"'}),"\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Debug with stdin and auto-submit"}),"\ndmesg | wsh ai -s - -m ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"help me understand these errors"'}),"\n"]})}),"\n",(0,i.jsx)(s.p,{children:(0,i.jsx)(s.strong,{children:"Flags:"})}),"\n",(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-"})," - Read from stdin instead of a file"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-m, --message"})," - Add message text along with files"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-s, --submit"})," - Auto-submit immediately (default is to wait for user)"]}),"\n",(0,i.jsxs)(s.li,{children:[(0,i.jsx)(s.code,{children:"-n, --new"})," - Clear chat and start fresh conversation"]}),"\n"]}),"\n",(0,i.jsx)(s.p,{children:(0,i.jsx)(s.strong,{children:"File Limits:"})}),"\n",(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsx)(s.li,{children:"Text files: 200KB max"}),"\n",(0,i.jsx)(s.li,{children:"PDFs: 5MB max"}),"\n",(0,i.jsx)(s.li,{children:"Images: 7MB max"}),"\n",(0,i.jsx)(s.li,{children:"Maximum 15 files per command"}),"\n"]}),"\n",(0,i.jsx)(s.h2,{id:"tips--features",children:"Tips & Features"}),"\n",(0,i.jsxs)(s.ol,{children:["\n",(0,i.jsxs)(s.li,{children:["\n",(0,i.jsx)(s.p,{children:(0,i.jsx)(s.strong,{children:"Working with Blocks"})}),"\n",(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsx)(s.li,{children:"Use block numbers (1-9) to target specific blocks within a tab (hold Ctrl+Shift to see block numbers)"}),"\n",(0,i.jsx)(s.li,{children:'Can get full block ids by right click a block\'s header and selecting "Copy Block Id" (useful for scripting)'}),"\n",(0,i.jsx)(s.li,{children:'Use references like "this", "tab", "workspace", or "global" for different scopes'}),"\n"]}),"\n"]}),"\n",(0,i.jsxs)(s.li,{children:["\n",(0,i.jsx)(s.p,{children:(0,i.jsx)(s.strong,{children:"Data Storage"})}),"\n",(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsxs)(s.li,{children:["Use ",(0,i.jsx)(s.code,{children:"wsh setvar/getvar"})," for configuration and secrets"]}),"\n",(0,i.jsxs)(s.li,{children:["Store file data using ",(0,i.jsx)(s.code,{children:"wsh file"}),", which can be easily referenced in all terminals (local and remote)"]}),"\n",(0,i.jsx)(s.li,{children:"Use appropriate storage scopes (block, tab, workspace, global)"}),"\n"]}),"\n"]}),"\n",(0,i.jsxs)(s.li,{children:["\n",(0,i.jsx)(s.p,{children:(0,i.jsx)(s.strong,{children:"Command Execution"})}),"\n",(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsxs)(s.li,{children:["Use ",(0,i.jsx)(s.code,{children:"wsh run"})," to execute commands in new blocks"]}),"\n",(0,i.jsxs)(s.li,{children:["Send command output and files quickly to AI blocks with ",(0,i.jsx)(s.code,{children:"wsh ai"})]}),"\n"]}),"\n"]}),"\n"]}),"\n",(0,i.jsx)(s.h2,{id:"scripting-with-wsh",children:"Scripting with wsh"}),"\n",(0,i.jsxs)(s.p,{children:["wsh commands can be combined in scripts to automate common tasks. Here's an example that sets up a development environment and uses ",(0,i.jsx)(s.code,{children:"wsh notify"})," to monitor a long-running build:"]}),"\n",(0,i.jsx)(s.pre,{children:(0,i.jsxs)(s.code,{className:"hljs language-bash",children:[(0,i.jsx)(s.span,{className:"hljs-meta",children:"#!/bin/bash"}),"\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Setup development environment"}),"\nwsh run -- docker-compose up -d\nwsh web open localhost:8080\nwsh view ./src\nwsh run -- npm run ",(0,i.jsx)(s.span,{className:"hljs-built_in",children:"test"}),":watch\n\n",(0,i.jsx)(s.span,{className:"hljs-comment",children:"# Get notified when long-running tasks complete using wsh notify"}),"\nnpm run build && wsh notify ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"Build complete"'})," || wsh notify ",(0,i.jsx)(s.span,{className:"hljs-string",children:'"Build failed"'}),"\n"]})}),"\n",(0,i.jsx)(s.h2,{id:"getting-help",children:"Getting Help"}),"\n",(0,i.jsxs)(s.p,{children:["You can get help on available commands by running ",(0,i.jsx)(s.code,{children:"wsh"})," with no arguments, or get detailed help for a specific command using ",(0,i.jsx)(s.code,{children:"wsh [command] -h"}),"."]}),"\n",(0,i.jsxs)(s.p,{children:["For a complete reference of all ",(0,i.jsx)(s.code,{children:"wsh"})," functionality, see the ",(0,i.jsx)(s.a,{href:"./wsh-reference",children:"WSH Command Reference"}),"."]})]})}function d(e={}){const{wrapper:s}={...(0,a.R)(),...e.components};return s?(0,i.jsx)(s,{...e,children:(0,i.jsx)(h,{...e})}):h(e)}}}]);